<?php

namespace model;

use DATABASE\Model;
use model\Entity\CitiesEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Cities extends Model {
	public $_table = 'tblCities';
	public $_key = 'city_id';
	public $_Entity = \model\Entity\CitiesEntity::class;
	
	public static function toOption() {
		$output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
		/** @var CitiesEntity $city */
		foreach (self::getAllActives() as $city) {
			$output[] = HtmlTags::Option()->Value("$city->city_id")->Content($city->city_name);
		}
		return implode('', $output);
	}
	
	public static function getClosest(string $lat, string $lng) {
		$query = "SELECT *, SQRT( POW(69.1 * (latitude - $lat), 2) + POW(69.1 * ($lng - longitude) * COS(latitude / 57.3), 2)) AS distance FROM tblCities HAVING distance < 5000000  ORDER BY distance LIMIT 1";
		$res = self::Db()->custom($query)->get();
		$res = $res->length() > 0 ? CitiesEntity::fromArray((array)$res->first) : Cities::Db()->limit(1)->get()->first;
		return $res->apiFormat();
	}
	
}
