<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class NegaShopCitiesMigration extends Migratable {
    const modelName = 'NegaShopCities';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('nega_shop_citie_id');
			$blueprint->Int('nega_shop_startup_id')->Len(150);
			$blueprint->Int('city_id')->Len(150);
			$blueprint->Int('nega_shop_city_id')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
