<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PaymentServiceMigration extends Migratable {
    const modelName = 'PaymentService';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('payment_servic_id');
			$blueprint->Int('startup_id')->Len(150);
			$blueprint->Int('payment_service_min_amount')->Len(150);
			$blueprint->VarChar('payment_service_max_amount')->Len(150);
			$blueprint->VarChar('payment_service_max_request')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
