<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ProviderCommentsMigration extends Migratable {
    const modelName = 'ProviderComments';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('provider_comment_id');
			$blueprint->Int('provider_to_startup_id')->Len(150);
			$blueprint->Text('provider_comment_text');
			$blueprint->Int('provider_comment_rating')->Len(150);
			$blueprint->Int('provider_comment_date')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
