<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ProviderLevelsMigration extends Migratable {
    const modelName = 'ProviderLevels';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('provider_level_id');
			$blueprint->VarChar('provider_level_name')->Len(150);
			$blueprint->VarChar('provider_level_details')->Len(150);
			$blueprint->VarChar('provider_level_difference')->Len(150);
			$blueprint->Int('level_id')->Len(150);
			$blueprint->Int('provider_level_startup_code')->Len(150);
			$blueprint->Int('startup_id')->Len(150);
			$blueprint->VarChar('provider_level_transaction_on_pose')->Len(150);
			$blueprint->VarChar('provider_level_amount_transaction_on_pose')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
