<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class CasteGroupToStartupMigration extends Migratable {
    const modelName = 'CasteGroupToStartup';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('caste_group_to_startu_id');
			$blueprint->VarChar('caste_group_to_startup_name')->Len(150);
			$blueprint->VarChar('caste_group_to_startup_key')->Len(150);
			$blueprint->Int('caste_ids')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
