<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PaymentServiceProvidersMigration extends Migratable {
    const modelName = 'PaymentServiceProviders';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('payment_service_provider_id');
			$blueprint->VarChar('payment_service_provider_name')->Len(150);
			$blueprint->Int('payment_service_provider_field_ids')->Len(150);
			$blueprint->Int('payment_service_provider_referrer_count')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
