<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PaymentServiceProviderFieldsMigration extends Migratable {
    const modelName = 'PaymentServiceProviderFields';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('payment_service_provider_field_id');
			$blueprint->VarChar('payment_service_provider_field_name')->Len(150);
			$blueprint->Int('payment_service_provider_field_is_required_yes_no')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
