<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ProviderPaymentsMigration extends Migratable {
    const modelName = 'ProviderPayments';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('provider_payment_id');
			$blueprint->VarChar('provider_payment_mobile')->Len(150);
			$blueprint->Int('provider_branch_id')->Len(150);
			$blueprint->Int('startup_id')->Len(150);
			$blueprint->Int('provider_payment_date')->Len(150);
			$blueprint->Int('payment_id')->Len(150);
			$blueprint->VarChar('provider_payment_resnum')->Len(150);
			$blueprint->VarChar('provider_payment_status')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
