<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class VoucherUseCodesMigration extends Migratable {
    const modelName = 'VoucherUseCodes';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('voucher_use_code_id');
			$blueprint->Int('voucher_code_id')->Len(150);
			$blueprint->VarChar('voucher_code_user_id')->Len(150);
			$blueprint->VarChar('voucher_code_user_date')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
