<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class VoucherCodeServicesMigration extends Migratable {
    const modelName = 'VoucherCodeServices';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('voucher_code_service_id');
			$blueprint->Int('startup_id')->Len(150);
			$blueprint->Int('voucher_code_id')->Len(150);
			$blueprint->VarChar('voucher_code_service_count')->Len(150);
			$blueprint->VarChar('voucher_code_service_user_count')->Len(150);
			$blueprint->VarChar('voucher_code_service_expire_date')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
