<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class VoucherCodesMigration extends Migratable {
    const modelName = 'VoucherCodes';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('voucher_code_id');
			$blueprint->VarChar('voucher_code')->Len(150);
			$blueprint->Int('voucher_code_provider_id')->Len(150);
			$blueprint->VarChar('voucher_code_count')->Len(150);
			$blueprint->VarChar('voucher_code_user_count')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
