<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ChargeOperatorsMigration extends Migratable {
    const modelName = 'ChargeOperators';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('charge_operator_id');
			$blueprint->VarChar('operator_name')->Len(150);
			$blueprint->VarChar('operator_code')->Len(150);
			$blueprint->VarChar('operator_image')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
