<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class VoucherCodeProvidersMigration extends Migratable {
    const modelName = 'VoucherCodeProviders';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('voucher_code_provider_id');
			$blueprint->VarChar('voucher_code_provider_name')->Len(150);
			$blueprint->VarChar('voucher_code_provider_icon')->Len(150);
			$blueprint->VarChar('voucher_code_provider_detail')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
