<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ProviderToProductMigration extends Migratable {
    const modelName = 'ProviderToProduct';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('provider_to_produc_id');
			$blueprint->Int('unit_id')->Len(150);
			$blueprint->VarChar('provider_to_product_for')->Len(150);
			$blueprint->VarChar('provider_to_product_price')->Len(150);
			$blueprint->Int('product_group_id')->Len(150);
			$blueprint->Int('product_sub_group_id')->Len(150);
			$blueprint->Int('product_sub_sub_group_id')->Len(150);
			$blueprint->Int('product_id')->Len(150);
			$blueprint->Int('provider_id')->Len(150);
			$blueprint->Int('provider_branch_id')->Len(150);
			$blueprint->VarChar('provider_to_product_image')->Len(150);
			$blueprint->Text('provider_to_product_description');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
