<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class UsersStartupsMigration extends Migratable {
    const modelName = 'UsersStartups';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('users_startup_id');
			$blueprint->Int('startup_id')->Len(150);
			$blueprint->Int('customer_id')->Len(150);
			$blueprint->Int('startup_user_credit')->Len(150);
			$blueprint->Int('startup_user_score')->Len(150);
			$blueprint->Int('startup_user_mobile')->Len(150);
			$blueprint->VarChar('startup_user_create')->Len(150);
			$blueprint->VarChar('startup_user_active')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
