<?php

use controller\Jobs;
use controller\Sizes;
use controller\Units;
use controller\Banks;
use controller\Brands;
use controller\Colors;
use controller\Levels;
use controller\Castes;
use controller\Ranges;
use controller\States;
use controller\Agencies;
use controller\Startups;
use controller\Materials;
use controller\Providers;
use controller\Customers;
use controller\BankCards;
use controller\Districts;
use controller\Countries;
use controller\PhotoMarks;
use controller\Educations;
use controller\WorkGroups;
use controller\Productions;
use controller\Individuals;
use FwHtml\FontAwesome as Fa;
use controller\Supervisions;
use controller\StartupUsers;
use controller\ProductsName;
use controller\BankAccounts;
use controller\ChargeCredit;
use controller\SocialMedias;
use controller\VoucherCodes;
use controller\GalleryGroups;
use controller\ProductGroups;
use controller\ContractTypes;
use controller\HotelServices;
use controller\FlightServices;
use controller\SimCardNumbers;
use controller\ChargeServices;
use controller\ProviderLevels;
use controller\NegaShopCities;
use controller\CustomerReports;
use controller\ProviderReports;
use controller\ChargeOperators;
use controller\GallerySubGroups;
use controller\ProductSubGroups;
use controller\Acceptorpictures;
use controller\ProviderBranches;
use controller\CreditConversion;
use controller\NegaShopStartups;
use controller\ProviderToStartup;
use controller\CustomerAddresses;
use controller\GalleryProductName;
use controller\GallerySubSubGroups;
use controller\ProductSubSubGroups;
use controller\VoucherCodeServices;
use controller\SocialMediaServices;
use controller\VoucherCodeProviders;
use controller\IdentificationSeries;
use controller\PaymentServiceProviders;
use controller\PaymentServiceProviderFields;

$SideBar = new Sidebar(true);
$SideBar->Item('تنظیمات پنل', Fa::Wrench())->_items([
	MenuItem::create('آموزش فرم ها', Fa::Pencil())->LinksTo('Labels/addLabels'),
]);
$SideBar->Item('اطلاعات جفرافیایی', Fa::Location_arrow())->_items([
	MenuItem::create('کشور', Fa::Location_arrow())->LinksTo(Countries::class),
	MenuItem::create('استان', Fa::Location_arrow())->LinksTo(States::class),
	//	MenuItem::create('شهر', Fa::Location_arrow())->LinksTo(Cities::class),
	MenuItem::create('منطقه', Fa::Location_arrow())->LinksTo(Districts::class),
	MenuItem::create('محدوده', Fa::Location_arrow())->LinksTo(Ranges::class),
]);
$SideBar->Item('اطلاعات پایه ای', Fa::Cogs())->_items([
	MenuItem::create('گروه کاری', Fa::Users())->LinksTo(WorkGroups::class),
	MenuItem::create('اصناف', Fa::List_ul())->LinksTo(Castes::class),
	MenuItem::create('تحصیلات', Fa::University())->LinksTo(Educations::class),
	MenuItem::create('مشاغل', Fa::Money())->LinksTo(Jobs::class),
	MenuItem::create('انواع قرارداد', Fa::Handshake_o())->LinksTo(ContractTypes::class),
	MenuItem::create('بانک ', Fa::Credit_card_alt())->LinksTo(Banks::class),
	MenuItem::create('پیش شماره کارت بانکی', Fa::Credit_card())->LinksTo(BankCards::class),
	MenuItem::create('شبکه های اجتماعی', Fa::Telegram())->LinksTo(SocialMedias::class),
	MenuItem::create('سری های شناسنامه', Fa::Telegram())->LinksTo(IdentificationSeries::class),
]);
$SideBar->Item('سرویس تخفیف', Fa::Cogs())->_items([
	MenuItem::create('تامین کننده های کد تخفیف', Fa::Telegram())->LinksTo(VoucherCodeProviders::class),
	MenuItem::create('کد های تخفیف', Fa::Telegram())->LinksTo(VoucherCodes::class),
	MenuItem::create('سرویس های تخفیف', Fa::Cc_discover())->LinksTo(VoucherCodeServices::class),
]);
$SideBar->Item('سرویس هتل', Fa::Home())->_items([
	MenuItem::create('سرویس های هتل', Fa::Hospital_o())->LinksTo(HotelServices::class),
]);
$SideBar->Item('سرویس شارژ', Fa::Phone())->_items([
	MenuItem::create('اپراتور ها', Fa::Superscript())->LinksTo(ChargeOperators::class),
	MenuItem::create('سرویس های شارژ', Fa::Superscript())->LinksTo(ChargeServices::class),
	MenuItem::create('پیش شماره ها', Fa::Superscript())->LinksTo(SimCardNumbers::class),
]);
$SideBar->Item('سرویس پرداخت', Fa::Phone())->_items([
	MenuItem::create('تنظیمات استارتاپ ها', Fa::Superscript())->LinksTo(\controller\PaymentService::class),
]);
$SideBar->Item('سرویس پرواز', Fa::Plane())->_items([
	MenuItem::create('سرویس های پرواز', Fa::Plane())->LinksTo(FlightServices::class),
]);
$SideBar->Item('سرویس شبکه های اجتماعی', Fa::Plane())->_items([
	MenuItem::create('قیمت گذاری سرویس ها', Fa::Plane())->LinksTo(SocialMediaServices::class),
	MenuItem::create('تخفیف سرویس ها در استارتاپ', Fa::Plane())->LinksTo('^levelDiscounts^SocialMedia/SocialMediaServices/SocialMediaServices'),
]);
$SideBar->Item('اشخاص', Fa::Users())->_items([
	MenuItem::create('اشخاص حقیقی', Fa::Male())->LinksTo(Individuals::class),
	MenuItem::create('مشتریان', Fa::User_plus())->LinksTo(Customers::class),
	MenuItem::create(' سطوح عضویت', Fa::List_ol())->LinksTo(Levels::class),
	MenuItem::create('آدرس ها', Fa::Location_arrow())->LinksTo(CustomerAddresses::class),
]);
$SideBar->Item('امتیاز و اعتبار', Fa::Users())->_items([
	MenuItem::create('تبدیل امتیاز و اعتبار', Fa::Male())->LinksTo(CreditConversion::class),
	MenuItem::create('شارژ اعتبار و امتیاز', Fa::Male())->LinksTo(ChargeCredit::class),
]);
$SideBar->Item('پذیرندگان', Fa::User_circle_o())->_items([
	MenuItem::create('پذیرندگان', Fa::User_plus())->LinksTo(Providers::class),
	MenuItem::create('شعب پذیرندگان', Fa::University())->LinksTo(ProviderBranches::class),
	MenuItem::create('گالری شعب پذیرندگان', Fa::Picture_o())->LinksTo(Acceptorpictures::class),
	MenuItem::create('حساب های بانکی', Fa::Credit_card())->LinksTo(BankAccounts::class),
	MenuItem::create('سطوح عضویت پذیرندگان', Fa::Credit_card())->LinksTo(ProviderLevels::class),
]);
//$SideBar->Item('حساب های بانکی', Fa::Wrench())->_items([
//    MenuItem::create('حساب های بانکی', Fa::Unlock())->LinksTo(\controller\BankAccounts::class),
//    ]);
$SideBar->Item('محصولات', Fa::Product_hunt())->_items([
	MenuItem::create('اطلاعات پایه  ', Fa::Wrench())->_items([
		MenuItem::create('واحد ', Fa::Tachometer())->LinksTo(Units::class),
		MenuItem::create('رنگ ', Fa::Paint_brush())->LinksTo(Colors::class),
		MenuItem::create('متریال', Fa::Cog())->LinksTo(Materials::class),
		MenuItem::create('برند ', Fa::Apple())->LinksTo(Brands::class),
		MenuItem::create('سایز ', Fa::Arrows_h())->LinksTo(Sizes::class),
		MenuItem::create('نوع تولید ', Fa::Cog())->LinksTo(Productions::class),
	]),
	MenuItem::create('محصولات ', Fa::Product_hunt())->_items([
		MenuItem::create('گروه ', Fa::Product_hunt())->LinksTo(ProductGroups::class),
		MenuItem::create('زیر گروه ', Fa::Product_hunt())->LinksTo(ProductSubGroups::class),
		MenuItem::create('زیر , زیر گروه ', Fa::Product_hunt())->LinksTo(ProductSubSubGroups::class),
		MenuItem::create('نام محصول ', Fa::Product_hunt())->LinksTo(ProductsName::class),
	]),
	MenuItem::create('گالری ها ', Fa::Picture_o())->_items([
		MenuItem::create('گالری گروه ها ', Fa::Picture_o())->LinksTo(GalleryGroups::class),
		MenuItem::create('گالری زیر گروه ها ', Fa::Picture_o())->LinksTo(GallerySubGroups::class),
		MenuItem::create('گالری زیر , زیر گروه ', Fa::Picture_o())->LinksTo(GallerySubSubGroups::class),
		MenuItem::create('گالری نام محصول ', Fa::Picture_o())->LinksTo(GalleryProductName::class),
		MenuItem::create('گالری برند ', Fa::Picture_o())->LinksTo(PhotoMarks::class),
	]),
]);
$SideBar->Item('تنظیمات باشگاه مشتریان', Fa::Cogs())->_items([
	MenuItem::create('مدیریت استارتاپ ها', Fa::Cog())->LinksTo(Startups::class),
	MenuItem::create('تخصیص پذیرنده به استارت آپ', Fa::Handshake_o())->LinksTo(ProviderToStartup::class),
	MenuItem::create('مدیریت مشتریان استارت آپ ها', Fa::User_plus())->LinksTo(StartupUsers::class),
	MenuItem::create('پی اس پی ها', Fa::Credit_card())->_items([
		MenuItem::create('فیلد های الزامی', Fa::Wrench())->LinksTo(PaymentServiceProviderFields::class),
		MenuItem::create('مدیریت پی اس پی ها', Fa::Credit_card_alt())->LinksTo(PaymentServiceProviders::class),
	]),
]);
$SideBar->Item('نگااپ', Fa::Cogs())->_items([
	MenuItem::create('مدیریت استارتاپ های نگاشاپ', Fa::Cog())->LinksTo(NegaShopStartups::class),
	MenuItem::create('شهر های واحد', Fa::Cog())->LinksTo(NegaShopCities::class),
]);
$SideBar->Item('مدیریت نگا کلاب', Fa::Cogs())->_items([
	MenuItem::create('سرپرستی مناطق', Fa::Location_arrow())->LinksTo(Supervisions::class),
	MenuItem::create('نمایندگی ها', Fa::Location_arrow())->LinksTo(Agencies::class),
]);
$SideBar->Item('گزارشات', Fa::Cogs())->_items([
	MenuItem::create('گزارش پذیرندگان', Fa::Location_arrow())->LinksTo(ProviderReports::class),
	MenuItem::create('گزارش مشتریان', Fa::Location_arrow())->LinksTo(CustomerReports::class),
]);
$SideBar->Item('Tools', Fa::Wrench())->_items([
	MenuItem::create('QUERY BUILDER', Fa::Times_circle_o())
		->LinksTo('QueryBuilder/QueryBuilder.fwTools'),
	MenuItem::create('MODEL GENERATOR', Fa::Times_circle_o())
		->LinksTo('modelGenerator/modelGenerator.fwTools'),
	MenuItem::create('Form Generator', Fa::Times_circle_o())
		->LinksTo('formGenerator/formGenerator.fwTools'),
	MenuItem::create('Data seeder', Fa::Times_circle_o())
		->LinksTo('DataSeeder/DataSeeder.fwTools'),
]);
$SideBar->render();
