<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class VoucherCodeProvidersEntity extends EntityScheme {
	public $voucher_code_provider_id;
	public $code_provider_name;
	
	public $code_provider_icon;
	
	public $code_provider_detail;
	
	
	public function model() {
		return new \model\VoucherCodeProviders();
	}
	
	
	protected function dictionary() : array {
		return [
			'id'                   => 'voucher_code_provider_id',
			'code_provider_name'   => 'voucher_code_provider_name',
			'code_provider_icon'   => 'voucher_code_provider_icon',
			'code_provider_detail' => 'voucher_code_provider_detail',
		];
	}
	
	public function apiFormat() {
		return [
			'id' => $this->voucher_code_provider_id,
			'name' => $this->code_provider_name,
			'logo' => __IMAGES__.'VoucherCodeProviders/'.$this->code_provider_icon,
		];
	}
}
