<?php

namespace model\Entity;

use model\PaymentService;
use FwHtml\Elements\Tags\Option;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class StartupsEntity extends EntityScheme {
	public $id;
	public $name;
	
	public $logo;
	
	public $ip;
	
	public $city_id;
	
	public $details;
	
	public $startup_percent;
	public $startup_hub_percent;
	
	public $score_to_club_score;
	public $club_score_from_score;
	public $score_to_club_credit;
	public $club_credit_from_score;
	public $credit_to_club_score;
	public $club_score_from_credit;
	
	public $referral_count;
	public $token;
	
	public function apiFormat() {
		return [
			'id'          => md5($this->id),
			'name'        => $this->name . '',
			'logo'        => is_file(__SOURCE__ . 'images/Startups/' . $this->logo) ? __IMAGES__ . 'Startups/' . $this->logo : __IMAGES__ . 'placeholder.png',
			'description' => $this->details . '',
		];
	}
	
	public function paymentActive() {
		return PaymentService::Db()->where($this->model()->_key, $this->id)->limit(1)->get()->first;
	}
	
	public function model() {
		return new \model\Startups();
	}
	
	protected function dictionary() : array {
		return [
			'id'                     => 'startup_id',
			'name'                   => 'startup_name',
			'logo'                   => 'startup_logo',
			'ip'                     => 'startup_ip',
			'token'                  => 'startup_token',
			'details'                => 'startup_details',
			'city_id'                => 'city_id',
			'score_to_club_score'    => 'score_to_club_score',
			'club_score_from_score'  => 'club_score_from_score',
			'score_to_club_credit'   => 'score_to_club_credit',
			'club_credit_from_score' => 'club_credit_from_score',
			'credit_to_club_score'   => 'credit_to_club_score',
			'club_score_from_credit' => 'club_score_from_credit',
			'startup_hub_percent'    => 'startup_hub_percent',
			'startup_percent'        => 'startup_percent',
			'referral_count'         => 'startup_referral_count',
		];
	}
	
	public function toOption() : Option {
		return HtmlTags::Option()->Value($this->id)->Content($this->name)->Data_('percent', $this->startup_percent + $this->startup_hub_percent);
	}
}
