<?php

namespace model\Entity;

use model\Levels;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class StartupUsersEntity extends EntityScheme {
	public $id;
	public $startup_id;
	public $customer_id;
	public $credit;
	public $score;
	public $mobile;
	public $create;
	public $active;
	public $level_id;
	public $parent;
	private $level;
	
	
	public function model() {
		return new \model\StartupUsers();
	}
	
	
	protected function dictionary() : array {
		return [
			'id'          => 'startup_user_id',
			'startup_id'  => 'startup_id',
			'customer_id' => 'customer_id',
			'level_id '   => 'level_id',
			'credit'      => 'startup_user_credit',
			'score'       => 'startup_user_score',
			'mobile'      => 'startup_user_mobile',
			'create'      => 'startup_user_create',
			'active'      => 'startup_user_active',
			'parent'      => 'startup_user_parent',
		];
	}
	
	public function apiFormat() {
		$level = Levels::get($this->level_id);
		return [
			'level'  => $level instanceof LevelsEntity ? $level->apiFormat() : NULL,
			'credit' => $this->credit > 0 ? "{$this->credit}" : '0',
			'score'  => $this->score > 0 ? "{$this->score}" : '0',
		];
	}
	
	/**
	 * @return LevelsEntity
	 */
	public function level() {
		if (!($this->level instanceof LevelsEntity)) $this->level = Levels::get($this->level_id);
		return $this->level;
	}
}
