<?php

namespace model\Entity;

use model\Individuals;
use model\ProviderBranches;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class ProvidersEntity extends EntityScheme {
	public $provider_id;
	public $name;
	public $image;
	public $individual_id;
	public $provider_tel;
	public $caste_id;
	public $social_media_id;
	public $provider_manager;
	public $workgroup_id;
	public $contracttype_id;
	public $provider_discount;
	public $provider_credit_discount;
	public $provider_month_settlement;
	public $provider_description;
	
	public function model() {
		return new \model\Startups();
	}
	
	protected function dictionary() : array {
		return [
			'provider_id'      => 'provider_id',
			'name'             => 'provider_name',
			'image'            => 'provider_image',
			'individual_id'    => 'individual_id',
			'provider_tel'     => 'provider_tel',
			'workgroup_id'     => 'workgroup_id',
			'caste_id'         => 'caste_id',
			'social_media_id'  => 'social_media_id',
			'provider_manager' => 'provider_manager',
		];
	}
	
	public function singleApiFormat() {
		return [
			'name'             => $this->name,
			'workgroup_id'     => $this->workgroup_id,
			'caste_id'         => $this->caste_id,
			'contracttype_id'  => $this->contracttype_id,
			'discount'         => $this->provider_discount,
			'credit_discount'  => $this->provider_credit_discount,
			'month_settlement' => $this->provider_month_settlement,
			'description'      => $this->provider_description,
			'image'            => "https://" . \FwConfig::HOST() . '/src/images/Providers/' . $this->provider_image,
		];
	}
	
	public function apiFormat() {
		/** @var IndividualsEntity $individual */
		$individual = Individuals::get($this->provider_manager);
		/** @var ProviderBranchesEntity $branch */
		$branch = ProviderBranches::Db()->where('provider_id', $this->provider_id)->orderBy('provider_branch_id', false)->limit(1)->get()->first;
		return [
			'id'              => $this->provider_id,
			"code"            => $this->provider_id,
			"discountPercent" => "$this->provider_discount",
			"fname"           => $individual->first_name,
			"lname"           => $individual->last_name,
			"mobile"          => $individual->mobile,
			"tel"             => CorrectMobile($this->provider_tel),
			"desc"            => "$this->provider_description",
			"lng"             => $branch->branch_longitude,
			"lat"             => $branch->branch_latitude,
			"name"            => $this->name,
			"avatar"          => __IMAGES__ . 'Providers/' . $this->image,
		];
		return [
			'name'             => $this->name,
			'workgroup_id'     => $this->workgroup_id,
			'caste_id'         => $this->caste_id,
			'contracttype_id'  => $this->contracttype_id,
			'discount'         => $this->provider_discount,
			'credit_discount'  => $this->provider_credit_discount,
			'month_settlement' => $this->provider_month_settlement,
			'description'      => $this->provider_description,
			'image'            => "https://" . \FwConfig::HOST() . '/src/images/Providers/' . $this->provider_image,
		];
	}
}
