<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class ProviderLevelsEntity extends EntityScheme {
	public $provider_level_id;
	/**
	 * عنوان سطح پذیرنده
	 **/
	public $level_name;
	/**
	 * توضیحات سطح عضویت
	 **/
	public $level_details;
	/**
	 * تفاضل با درصد تخفیف صنف
	 **/
	public $level_difference;
	/**
	 * سطح عضویت همتا در باشگاه مشتریان
	 **/
	public $level_id;
	/**
	 * کد در استارتاپ
	 **/
	public $level_startup_code;
	/**
	 * استارتاپ
	 **/
	public $startup_id;
	/**
	 * هر تراکنش در دستگاه کارتخوان متصل به باشگاه
	 **/
	public $level_transaction_on_pose;
	/**
	 * هر ۱۰۰۰۰ ریال تراکنش در دستگاه کارتخوان متصل به باشگاه
	 **/
	public $level_amount_transaction_on_pose;
	public $provider_level_icon;
	
	public function model() {
		return new \model\ProviderLevels();
	}
	
	
	protected function dictionary() : array {
		return [
			'provider_level_id'                => 'provider_level_id',
			'level_name'                       => 'provider_level_name',
			'level_details'                    => 'provider_level_details',
			'level_difference'                 => 'provider_level_difference',
			'level_id'                         => 'level_id',
			'level_startup_code'               => 'provider_level_startup_code',
			'startup_id'                       => 'startup_id',
			'level_transaction_on_pose'        => 'provider_level_transaction_on_pose',
			'level_amount_transaction_on_pose' => 'provider_level_amount_transaction_on_pose',
			'provider_level_icon'              => 'provider_level_icon',
		];
	}
	
	public function apiFormat() {
		return [
			'id'      => $this->provider_level_id,
			'name'    => $this->level_name,
			'details' => $this->level_details,
			'icon'    => is_file(__SOURCE__ . 'images/ProviderLevels/' . $this->provider_level_icon) ? __IMAGES__ . 'ProviderLevels/' . $this->provider_level_icon : '',
		];
	}
}
