<?php

namespace model\Entity;

use model\Cities;
use model\Ratings;
use model\Startups;
use model\Providers;
use model\Individuals;
use model\ProviderLevels;
use model\ProviderBranches;
use model\ProviderComments;
use model\ProviderToStartup;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class ProviderToStartupEntity extends EntityScheme {
	public $provider_to_startup_id;
	public $branch_id;
	
	public $to_startup_contract_number;
	
	public $to_startup_start_date;
	
	public $to_startup_end_date;
	
	public $contracttype_id;
	
	public $to_startup_cash_discount;
	public $startup_percent;
	public $cashback_percent;
	
	public $to_startup_credit_discount;
	
	public $to_startup_cash_and_credit_discount;
	
	public $to_startup_each_buy;
	
	public $to_startup_score_per_buy;
	
	public $provider_id;
	public $startup_id;
	public $is_universal;
	public $provider_banner;
	/**
	 * @var float|int
	 */
	public $credit;
	public $provider_level_id;
	public $provider_view;
	
	
	public function model() {
		return new ProviderToStartup();
	}
	
	
	protected function dictionary() : array {
		return [
			'id'                                        => 'provider_to_startup_id',
			'branch_id'                                 => 'provider_branch_id',
			'to_startup_contract_number'                => 'provider_to_startup_contract_number',
			'to_startup_start_date'                     => 'provider_to_startup_start_date',
			'to_startup_end_date'                       => 'provider_to_startup_end_date',
			'contracttype_id'                           => 'contracttype_id',
			'to_startup_cash_discount'                  => 'provider_to_startup_cash_discount',
			'cashback_percent'                          => 'provider_cashback_percent',
			'startup_percent'                           => 'provider_startup_percent',
			'to_startup_credit_discount'                => 'provider_to_startup_credit_discount',
			'provider_to_startup_month_ssettlement_div' => 'provider_to_startup_month_ssettlement_div',
			'to_startup_each_buy'                       => 'provider_to_startup_each_buy',
			'to_startup_score_per_buy'                  => 'provider_to_startup_score_per_buy',
			'provider_id'                               => 'provider_id',
			'provider_level_id'                         => 'provider_level_id',
			'startup_id'                                => 'startup_id',
			'is_universal'                              => 'is_universal',
			'provider_banner'                           => 'provider_banner',
			'provider_view'                             => 'provider_view',
			'credit'                                    => 'provider_credit',
		];
	}
	
	public function apiFormat() {
		/** @var ProvidersEntity $provider */
		$provider = Providers::get($this->provider_id);
		/** @var IndividualsEntity $individual */
		$individual = Individuals::get($provider->provider_manager);
		/** @var ProviderBranchesEntity $branch */
		$branch = ProviderBranches::Db()->where('provider_id', $this->provider_id)->orderBy('provider_branch_id', false)->limit(1)->get()->first;
		/** @var StartupsEntity $startup */
		$startup = Startups::get($this->startup_id);
		/** @var ProviderLevelsEntity $providerLevel */
		$providerLevel = ProviderLevels::get($this->provider_level_id);
		$avg = ProviderComments::Db()->custom("SELECT AVG(provider_comment_rating) as average FROM tblProviderComments where provider_to_startup_id = {$this->provider_to_startup_id}")->get();
		return [
			'id'              => $this->provider_id,
			"code"            => $this->provider_id,
			'rate'            => (double)($avg->first->average > 0 ? (double)($avg->first->average / 2) : 0.0),
			'providerLevel'   => $providerLevel->apiFormat(),
			'views'           => $this->provider_view,
			"discountPercent" => ($this->to_startup_cash_discount - ($startup->startup_hub_percent + $startup->startup_percent)) . '',
			"fname"           => $individual->first_name,
			"lname"           => $individual->last_name,
			"mobile"          => $individual->mobile,
			//			'rate'            => ,
			"tel"             => CorrectMobile($provider->provider_tel),
			"desc"            => "$provider->provider_description",
			"lng"             => (double)$branch->branch_longitude,
			"lat"             => (double)$branch->branch_latitude,
			"name"            => $provider->name,
			"avatar"          => str($provider->image)->len() > 5 ? __IMAGES__ . 'Providers/' . $provider->image : __IMAGES__ . 'Startups/' . $startup->logo,
		];
	}
	
	public function singleApiFormat() {
		
		/** @var ProvidersEntity $provider */
		$provider = Providers::get($this->provider_id);
		/** @var IndividualsEntity $individual */
		$individual = Individuals::get($provider->provider_manager);
		/** @var ProviderBranchesEntity $branch */
		$branch = ProviderBranches::Db()->where('provider_id', $this->provider_id)->orderBy('provider_branch_id', false)->limit(1)->get()->first;
		/** @var StartupsEntity $startup */
		$startup = Startups::get($this->startup_id);
		$providerLevel = ProviderLevels::get($this->provider_level_id);
		
		$avg = ProviderComments::Db()->custom("SELECT AVG(provider_comment_rating) as average FROM tblProviderComments where provider_to_startup_id = {$this->provider_to_startup_id}")->get();
		return [
			'provider_code'   => $this->provider_id,
			'senf_name'       => "$provider->name",
			'providerLevel'   => $providerLevel->apiFormat(),
			
			'rate'            => (double)($avg->first->average > 0 ? (double)($avg->first->average / 2) : 0.0),
			'views'           => $this->provider_view,
			'full_name'       => $individual->first_name . ' ' . $individual->last_name,
			'mobile'          => CorrectMobile($individual->mobile),
			'telephone'       => CorrectMobile($provider->provider_tel),
			'city_name'       => Cities::get($branch->city_id)->city_name,
			'main_street'     => "$branch->branch_main_street",
			'latitude'        => $branch->branch_latitude > 0 ? "$branch->branch_latitude" : 0,
			'longitude'       => $branch->branch_longitude > 0 ? "$branch->branch_longitude" : 0,
			"avatar"          => str($provider->image)->len() > 5 ? __IMAGES__ . 'Providers/' . $provider->image : __IMAGES__ . 'Startups/' . $startup->logo,
			'description'     => "$provider->provider_description",
			'discount_credit' => ($this->to_startup_credit_discount - ($startup->startup_hub_percent + $startup->startup_percent)) . '',
			'discount_cash'   => (($this->to_startup_cash_discount - ($startup->startup_hub_percent + $startup->startup_percent))) . '',
			'pic'             => [],
		];
	}
	
	
	public function getMobile() {
		
		/** @var ProvidersEntity $provider */
		$provider = Providers::get($this->provider_id);
		/** @var IndividualsEntity $individual */
		$individual = Individuals::get($provider->individual_id);
		return $individual->mobile;
	}
}
