<?php

namespace model\Entity;

use FwHtml\Elements\Tags\Option;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class LevelsEntity extends EntityScheme {
	public $level_id;
	public $title;
	public $discount_percent;
	public $credit_return_percent;
	public $min_score_join;
	public $unit_score_to_credit;
	public $unit_credit;
	public $card_issuance;
	public $description;
	public $register_site;
	public $login_once_day;
	public $basic_profile_information;
	public $additional_information;
	public $score_buy;
	public $score_buy_amount;
	public $introduc_newuser;
	public $record_comment;
	public $record_score;
	public $score_wallet;
	public $min_score;
	public $min_credit;
	public $startup_id;
	public $level_code;
	public $image;
	public $price;
	public $level_max_card_count;
	
	public function model() {
		return new \model\Levels();
	}
	
	
	protected function dictionary() : array {
		return [
			"level_id"                  => 'level_id',
			"title"                     => 'level_title',
			"price"                     => 'level_price',
			"discount_percent"          => 'level_discount_percent',
			"credit_return_percent"     => 'level_credit_return_percent',
			"min_score_join"            => 'level_min_score_join',
			"unit_score_to_credit"      => 'level_unit_score_to_credit',
			"unit_credit"               => 'level_unit_credit',
			"card_issuance"             => 'level_card_issuance',
			"description"               => 'level_description',
			"register_site"             => 'level_register_site',
			"login_once_day"            => 'level_login_once_day',
			"basic_profile_information" => 'level_basic_profile_information',
			"additional_information"    => 'level_additional_information',
			"score_buy"                 => 'level_score_buy',
			"score_buy_amount"          => 'level_score_buy_amount',
			"introduc_newuser"          => 'level_introduc_newuser',
			"record_comment"            => 'level_record_comment',
			"record_score"              => 'level_record_score',
			"score_wallet"              => 'level_score_wallet',
			"min_score"                 => 'level_min_score',
			"min_credit"                => 'level_min_credit',
			"startup_id"                => 'startup_id',
			"level_code"                => 'level_code',
			"level_max_card_count"      => 'level_max_card_count',
			"image"                     => 'level_image',
		];
	}
	
	public function toOption() : Option {
		return HtmlTags::Option()->Value($this->level_id)->Content($this->title);
	}
	
	public function apiFormat() {
		
		return [
			'id'                    => $this->level_id,
			'title'                 => $this->title,
			'discountPercent'       => $this->discount_percent,
			'price'                 => $this->price,
			'cashbackPercent'       => $this->credit_return_percent,
			'minScoreToJoin'        => $this->min_score_join,
			'scoreToCredit'         => $this->unit_score_to_credit,
			'unitCredit'            => $this->unit_credit,
			'isCardIssued'          => $this->card_issuance,
			'description'           => $this->description,
			'webSiteRegisterScore'  => $this->register_site,
			'loginPerDayScore'      => $this->login_once_day,
			'baseProfileInfoScore'  => $this->basic_profile_information,
			'additionalInfoScore'   => $this->additional_information,
			'purchaseScore'         => $this->score_buy,
			'purchasePerTomanScore' => $this->score_buy_amount,
			'referScore'            => $this->introduc_newuser,
			'commentScore'          => $this->record_comment,
			'rateScore'             => $this->record_score,
			'chargeWalletScore'     => $this->score_wallet,
			'minScore'              => $this->min_score,
			'minCredit'             => $this->min_credit,
			'maxCardCount'          => $this->level_max_card_count,
			'levelCode'             => $this->level_code,
			'image'                 => __IMAGES__ . 'Levels/' . $this->image,
		];
	}
}
