<?php

namespace model\Entity;

use model\Banks;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class CreditCardsEntity extends EntityScheme {
	public $credit_card_id;
	/**
	 * انتخاب مشتری
	 **/
	public $customer_id;
	/**
	 * بانک
	 **/
	public $bank_id;
	/**
	 * شماره کارت
	 **/
	public $card_number;
	/**
	 * cvv2
	 **/
	public $card_cvv2;
	/**
	 * ماه انقضا
	 **/
	public $card_expire_month;
	/**
	 * سال انقضا
	 **/
	public $card_expire_year;
	
	public function model() {
		return new \model\CreditCards();
	}
	
	
	protected function dictionary() : array {
		return [
			'credit_card_id'    => 'credit_card_id',
			'customer_id'       => 'customer_id',
			'bank_id'           => 'bank_id',
			'card_number'       => 'credit_card_number',
			'card_cvv2'         => 'credit_card_cvv2',
			'card_expire_month' => 'credit_card_expire_month',
			'card_expire_year'  => 'credit_card_expire_year',
		];
	}
	
	public function apiFormat() {
		/** @var BanksEntity $bank */
		$bank = Banks::get($this->bank_id);
		return [
			'id'         => $this->credit_card_id,
			'bank'       => $bank instanceof BanksEntity ? $bank->apiFormat() : NULL,
			'number'     => (string)fa_to_en($this->card_number),
			'cvv2'       => fa_to_en($this->card_cvv2),
			'expiration' => fa_to_en($this->card_expire_year) . '/' . fa_to_en($this->card_expire_month),
		];
	}
}
