<?php

namespace model\Entity;

use model\Startups;
use FwHtml\Elements\Tags\Option;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class NegaShopStartupsEntity extends EntityScheme {
	public $nega_shop_startup_id;
	/**
	 * انتخاب استارتاپ
	 **/
	public $startup_id;
	/**
	 * آیکون
	 **/
	public $negashop_startup_id;
	
	public function model() {
		return new \model\NegaShopStartups();
	}
	
	
	protected function dictionary() : array {
		return [
			'nega_shop_startup_id' => 'nega_shop_startup_id',
			'startup_id'           => 'startup_id',
			'negashop_startup_id'  => 'negashop_startup_id',
		];
	}
	
	public function toOption() : Option {
		/** @var StartupsEntity $startup */
		$startup = Startups::get($this->startup_id);
		return HtmlTags::Option()->Value($this->nega_shop_startup_id)->Content($startup->name);
	}
}
