<?php

namespace controller;

use ControllerScheme;
use Api\ApiInterface;
use model\Entity\LatestNewsEntity;

class LatestNews extends ControllerScheme {
	use ApiInterface;
	
	const name = 'خبر';
	
	public static $__uploads = ["latest_news_cover" => __SOURCE__ . "images/LatestNews/"];
	
	
	public function allNews() {
		$this->setIsDone();
		return $this->model()::getAllActives()->map(function (LatestNewsEntity $entity) {
			return $entity->apiFormat();
		});
	}
	
	public function mainNews() {
		$this->setIsDone();
		return $this->model()::Db()->orderBy('')->get()->filter(function (LatestNewsEntity $entity) {
			return isActive($this, $entity);
		})->limit(3)->map(function (LatestNewsEntity $entity) {
			return $entity->apiFormat();
		});
	}
}
