<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class LatestNewsEntity extends EntityScheme {
	public $latest_new_id;
	/**
	 * تیتر خبر
	 **/
	public $news_title;
	/**
	 * تصویر کاور
	 **/
	public $news_cover;
	/**
	 * خلاصه توضیحات
	 **/
	public $news_summary;
	/**
	 * متن خبر
	 **/
	public $news_text;
	
	public function model() {
		return new \model\LatestNews();
	}
	
	
	protected function dictionary() : array {
		return [
			'latest_new_id' => 'latest_new_id',
			'news_title'    => 'latest_news_title',
			'news_cover'    => 'latest_news_cover',
			'news_summary'  => 'latest_news_summary',
			'news_text'     => 'latest_news_text',
		];
	}
	
	public function apiFormat() {
		return [
			'id'      => $this->latest_new_id,
			'title'   => $this->news_title,
			'summary' => $this->news_summary,
			'cover'   => __IMAGES__ . 'LatestNews/' . $this->news_cover,
			'text'    => $this->news_text,
			'date' => 'اخیرا منتشر شده',
		];
	}
}
