<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class ChargeOperatorsEntity extends EntityScheme {
	public $charge_operator_id;
	public $operator_name;
	
	public $operator_code;
	
	public $operator_image;
	public $ask_amount_yes_no;
	public $short;
	
	
	public function model() {
		return new \model\ChargeOperators();
	}
	
	
	protected function dictionary() : array {
		return [
			'id'                => 'charge_operator_id',
			'operator_name'     => 'operator_name',
			'operator_code'     => 'operator_code',
			'operator_image'    => 'operator_image',
			'short'             => 'operator_short',
			'ask_amount_yes_no' => 'ask_amount_yes_no',
		];
	}
	
	public function apiFormat() {
		return [
			'id'        => (int)$this->charge_operator_id,
			'name'      => $this->operator_name,
			'short'     => $this->short,
			'askAmount' => $this->ask_amount_yes_no == 1,
			'logo'      => __IMAGES__ . 'ChargeOperators/' . $this->operator_image,
		];
	}
}
