<?php

namespace model\Entity;

use model\PaymentServiceProviderFields;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class PaymentServiceProvidersEntity extends EntityScheme {
	public $payment_service_provider_id;
	/**
	 * نام PSP
	 **/
	public $service_provider_name;
	/**
	 * فیلد های الزامی
	 **/
	public $service_provider_field_ids;
	/**
	 * تعداد معرف الزامی
	 **/
	public $service_provider_referrer_count;
	
	public function model() {
		return new \model\PaymentServiceProviders();
	}
	
	
	protected function dictionary() : array {
		return [
			'payment_service_provider_id'     => 'payment_service_provider_id',
			'service_provider_name'           => 'payment_service_provider_name',
			'service_provider_field_ids'      => 'payment_service_provider_field_ids',
			'service_provider_referrer_count' => 'payment_service_provider_referrer_count',
		];
	}
	
	public function apiFormat() {
		return [
			'id'            => $this->payment_service_provider_id,
			'name'          => $this->service_provider_name,
			'fields'        => collect(json_decode($this->service_provider_field_ids, true))->map(function ($id) {
				/** @var PaymentServiceProviderFieldsEntity $field */
				$field = PaymentServiceProviderFields::get($id);
				return $field->apiFormat();
			}),
			'referrerCount' => $this->service_provider_referrer_count,
		];
	}
}
