<?php

namespace model\Entity;

use model\PaymentServiceProviderFields;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class PaymentServiceProviderFieldsEntity extends EntityScheme {
	public $payment_service_provider_field_id;
	/**
	 * نام فیلد
	 **/
	public $name;
	/**
	 * اجباری است؟
	 **/
	public $is_required;
	
	public function model() {
		return new PaymentServiceProviderFields();
	}
	
	
	protected function dictionary() : array {
		return [
			'payment_service_provider_field_id' => 'payment_service_provider_field_id',
			'name'                              => 'payment_service_provider_field_name',
			'is_required'                       => 'payment_service_provider_field_is_required_yes_no',
		];
	}
	
	public function apiFormat() {
		return [
			'id'         => $this->payment_service_provider_field_id,
			'name'       => $this->name,
			'isRequired' => $this->is_required == 1,
		];
	}
	
	
}
