<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class IdentificationSeriesEntity extends EntityScheme {
	public $identification_serial_id;
	/**
	 * سری
	 **/
	public $serial_name;
	/**
	 * توضیحات سری
	 **/
	public $serial_details;
	
	public function model() {
		return new \model\IdentificationSeries();
	}
	
	
	protected function dictionary() : array {
		return [
			'identification_serial_id' => 'identification_serial_id',
			'serial_name'              => 'identification_serial_name',
			'serial_details'           => 'identification_serial_details',
		];
	}
	
	public function apiFormat() {
		return [
			'id'      => $this->identification_serial_id,
			'name'    => $this->serial_name,
			'details' => $this->serial_details,
		];
	}
}
