<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class CastesEntity extends EntityScheme {
	public $caste_id;
	public $name;
	public $workgroup_id;
	public $icon;
	public $minimum_percent;
	public $ceil_amount;
	
	public function model() {
		return new \model\Castes();
	}
	
	
	protected function dictionary() : array {
		return [
			'caste_id'        => 'caste_id',
			'name'            => 'caste_name',
			'workgroup_id'    => 'workgroup_id',
			'icon'            => 'caste_icon',
			'minimum_percent' => 'minimum_percent',
			'ceil_amount'     => 'ceil_amount',
		];
	}
	
	public function apiFormat() {
		return [
			'id'             => $this->caste_id,
			'workgroup_id'   => $this->workgroup_id,
			'name'           => $this->name,
			'minimumPercent' => $this->minimum_percent,
			'icon'           => __IMAGES__ . 'Castes/' . $this->icon,
		];
	}
}
