<?php

namespace model\Entity;

use model\Castes;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class CasteGroupToStartupEntity extends EntityScheme {
	public $caste_group_to_startup_id;
	/**
	 * نام دسته
	 **/
	public $group_to_startup_name;
	/**
	 * کلید
	 **/
	/**
	 * کد استارتاپ
	 **/
	public $group_to_startup_key;
	public $startup_id;
	/**
	 * اصناف
	 **/
	public $ids;
	
	public function model() {
		return new \model\CasteGroupToStartup();
	}
	
	
	protected function dictionary() : array {
		return [
			'caste_group_to_startup_id' => 'caste_group_to_startup_id',
			'group_to_startup_name'     => 'caste_group_to_startup_name',
			'group_to_startup_key'      => 'caste_group_to_startup_key',
			'startup_id'                => 'startup_id',
			'ids'                       => 'caste_ids',
		];
	}
	
	public function apiFormat() {
		return [
			'name' => $this->group_to_startup_name,
			'key' => $this->group_to_startup_key,
			'castes' => collect(json_decode($this->ids,true))->map(function ($id){
				$caste = Castes::get($id);
				return $caste instanceof CastesEntity ? $caste->apiFormat() : NULL;
			}),
		];
	}
}
