<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class BanksEntity extends EntityScheme {
	public $bank_id;
	public $name;
	public $logo;
	public $number;
	
	
	public function model() {
		return new \model\Banks();
	}
	
	
	protected function dictionary() : array {
		return [
			'id'     => 'bank_id',
			'name'   => 'bank_name',
			'logo'   => 'bank_logo',
			'number' => 'bank_number',
		];
	}
	
	public function apiFormat() {
		return [
			'id'   => $this->bank_id,
			'name' => $this->name,
			'logo' => __IMAGES__ . 'Banks/' . $this->logo,
		];
	}
}
