<?php

namespace payment;

use stdClass;
use fwJson\Json;
use PaymentHelpers;
use DATABASE\Model;
use PaymentInterface;
use PayingUserInterface;

abstract class BasePayment {
	
	public $chargeServiceBankId;
	public $_amount = 0;
	/**
	 * @var Model|PaymentInterface
	 */
	public $PaymentModel = NULL;
	/**
	 * @var Model|PayingUserInterface
	 */
	public $UserModel = NULL;
	/**
	 * @var string
	 */
	public $ResNum = 0;
	public $Helpers;
	/**
	 * @var Json
	 */
	protected $OrderData;
	protected $_user_id = 0;
	protected $isToman = true;
	/**
	 * @var stdClass
	 */
	protected $UserData = NULL;
	protected $Address = NULL;
	/**
	 * @var string
	 */
	protected $type = 'pay_for_cart';
	
	public function __construct($PaymentHelper = NULL) {
		$this->Address = new Json([]);
		$this->OrderData = new Json([]);
		if (is_object($PaymentHelper)) $this->Helpers = $PaymentHelper;
	}

	public function OrderData(Json $json) {
		$this->OrderData = $json;
	}
	
	public function initPayment(PaymentInterface $paymentModel) {
		$this->PaymentModel = $paymentModel;
		return $this;
	}
	
	public function UserModel(PayingUserInterface $param, $user_data) {
		$this->UserModel = $param;
		$this->UserData = $user_data;
		return $this;
	}
	
	public function Amount($full_price) {
		if ($this->isToman) $full_price = $full_price * 10;
		$this->_amount = $full_price;
		return $this;
	}
	
	public function Address($get) {
		$this->Address = $get;
		return $this;
	}
	
	public function Type(string $string) {
		$this->type = $string;
	}
	
	protected function CreateResNum() {
		$field = $this->PaymentModel->ResNumField();
		$res_num = UniqueOfClass($this->PaymentModel, $field, false, 12, true);
		$this->ResNum = $res_num;
		return $this->ResNum;
	}
}
