<?php

namespace DATABASE\ORM\Interact\Entities;

use fwJson\Json;
use ArrayAccess;
use PDOStatement;
use DATABASE\Model;
use ReflectionProperty;
use ReflectionException;
use FwHtml\Elements\Tags\Option;
use FwCollection\src\BaseCollection;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

if (!class_exists('DATABASE\ORM\Interact\Entities\EntityScheme')) {
	
	abstract class EntityScheme extends BaseEntity implements ArrayAccess {
		private $isConstructed;
		
		/**
		 * @param bool $byDict
		 *
		 * @return array
		 */
		public function toArray(bool $byDict = false) : array {
			$output = [];
			try {
				if (!$byDict) {
					foreach (get_object_vars($this) as $var => $value) {
						$Reflect = new ReflectionProperty($this, $var);
						if ($Reflect->isPublic() and isset($value)) {
							$output[$var] = $value;
						}
					}
				} else {
					foreach (get_object_vars($this) as $var => $value) {
						$Reflect = new ReflectionProperty($this, $var);
						if ($Reflect->isPublic() and isset($value)) {
							if ($this->dictionary()[$var]) {
								$var = $this->dictionary()[$var];
							}
							$output[$var] = $value;
						}
					}
				}
			} catch(ReflectionException $exception) {
			
			}
			return $output;
		}
		
		
		public function clone() {
			return self::fromArray($this->toArray());
		}
		
		public function setActive() {
			$db = Db::table('tblActiveList');
			if (!$db->where([
				'item_id'    => $this->{$this->model()->_key},
				'table_name' => $this->model()->_table,
			])->get()->first()) {
				$res = $db->insert([
					'item_id'    => $this->{$this->model()->_key},
					'table_name' => $this->model()->_table,
					'date'       => time(),
					'user_id'    => '-1',
				]);
				if ($res) {
					return 1;
				} else {
					return 0;
				}
			} else {
				return 500;
			}
		}
		
		public function deActive() {
			$db = Db::table('tblActiveList');
			if ($db->where([
				'item_id'    => $this->{$this->model()->_key},
				'table_name' => $this->model()->_table,
			])->get()->first()) {
				$res = $db->where([
					'item_id'    => $this->{$this->model()->_key},
					'table_name' => $this->model()->_table,
				])->delete();
				if ($res) {
					return 2;
				} else {
					return 0;
				}
			} else {
				return 404;
			}
		}
		
		/**
		 * @return Model
		 */
		abstract public function model();
		
		
		/**
		 * EntityScheme constructor.
		 */
		public function __construct() {
			$this->isConstructed = !(debug_backtrace()[1]['object'] instanceof PDOStatement);
		}
		
		/**
		 * @param int $options
		 *
		 * @return Json
		 */
		public function toJson($options = 0) : Json {
			return Json::encode(get_object_vars($this));
		}
		
		public function toOption() : Option {
			return $this->__toOption('name');
		}
		
		/**
		 * @param string $contentKey
		 * @param string $keyValue
		 *
		 * @return Option
		 */
		final protected function __toOption(string $contentKey, string $keyValue = '') : Option {
			if ($keyValue === '') $keyValue = $this->model()->_key;
			return HtmlTags::Option()->Value($this->$keyValue)->Content("{$this->$contentKey}");
		}
		
		/**
		 * @return array|mixed
		 */
		public function jsonSerialize() {
			return get_object_vars($this);
		}
		
		/**
		 * @param string $jsonString
		 *
		 * @return BaseCollection|static
		 */
		public static function fromJson(string $jsonString) {
			$decode = json_decode($jsonString, true);
			return static::fromArray($decode);
		}
		
		/**
		 * @param $name
		 * @param $value
		 */
		public function __set($name, $value) {
			if ($name != '') {
				$dict = $this->dictionary();
				$key = array_search($name, $dict);
				if ($key) {
					$this->{$key} = $value;
				} else {
					$this->$name = $value;
				}
			}
		}
		
		public function __get($name) {
			if ($name != '') {
				$dict = $this->dictionary();
				$key = array_search($name, $dict);
				if ($key and isset($this->$key)) {
					return $this->{$key};
				} elseif (isset($this->$name)) {
					return $this->{$name};
				} else {
					switch ($name) {
						case "id":
							return $this->{array_search($this->model()->_key, $this->dictionary())};
					}
				}
			}
		}
		
		
		/**
		 * @return array
		 */
		protected function dictionary() : array {
			$output = [];
			$vars = get_object_vars($this);
			foreach ($vars as $var => $value) {
				$output[$var] = $var;
			}
			return $output;
		}
		
		/**
		 * @param array $array
		 *
		 * @return BaseCollection|static
		 */
		static function fromArray(array $array) {
			switch (CountDimensions($array)) {
				case 1:
					$instance = new static();
					foreach ($array as $key => $value) {
						$instance->$key = $value;
					}
					return $instance;
				case 2:
					$output = [];
					foreach ($array as $item) {
						$instance = new static();
						foreach ($item as $key => $value) {
							$instance->$key = $value;
						}
						$output[] = $instance;
					}
					return collect($output);
			}
			return new static();
		}
		
		public function __debugInfo() {
			return $this->toArray();
		}
		
		/**
		 * @param string $upsertField
		 *
		 * @return bool|int
		 */
		public function save(string $upsertField = '') {
			$res = Db::tableFromEntity($this->model()->_table, $this);
			$arrayData = $this->toArray(true);
			unset($arrayData[$this->model()->_key]);
			if ($upsertField == '') {
				if ($this->isConstructed and !($this->model()::get($this->{array_search($this->model()->_key, $this->dictionary())}) instanceof static)) {
					$id = $res->insertWithId($arrayData);
					$this->{array_search($this->model()->_key, $this->dictionary())} = $id;
					return $id;
				}
				return $res->where($this->model()->_key, $this->{array_search($this->model()->_key, $this->dictionary())})->update($arrayData);
			} else {
				$data = $this->model()::getOneFiltered($this->byDictionary($upsertField), $this->{$upsertField});
				if ($data instanceof static) {
					$this->{array_search($this->model()->_key, $this->dictionary())} = $data->{array_search($this->model()->_key, $this->dictionary())};
					return $res->where($this->byDictionary($upsertField), $this->{$upsertField})->update($arrayData);
				} else {
					$id = $res->insertWithId($arrayData);
					$this->{array_search($this->model()->_key, $this->dictionary())} = $id;
					return $id;
				}
			}
		}
		
		/**
		 * @return bool
		 */
		public function delete() {
			$res = Db::tableFromEntity($this->model()->_table, $this);
			return $res->where($this->model()->_key, $this->{array_search($this->model()->_key, $this->dictionary())})->delete();
		}
		
		
		/**
		 * Whether a offset exists
		 *
		 * @link https://php.net/manual/en/arrayaccess.offsetexists.php
		 *
		 * @param mixed $offset <p>
		 * An offset to check for.
		 * </p>
		 *
		 * @return bool true on success or false on failure.
		 * </p>
		 * <p>
		 * The return value will be casted to boolean if non-boolean was returned.
		 */
		public function offsetExists($offset) {
			return property_exists($this, $offset);
		}
		
		/**
		 * Offset to retrieve
		 *
		 * @link https://php.net/manual/en/arrayaccess.offsetget.php
		 *
		 * @param mixed $offset <p>
		 * The offset to retrieve.
		 * </p>
		 *
		 * @return mixed Can return all value types.
		 */
		public function offsetGet($offset) {
			return $this->{$offset};
		}
		
		/**
		 * Offset to set
		 *
		 * @link https://php.net/manual/en/arrayaccess.offsetset.php
		 *
		 * @param mixed $offset <p>
		 * The offset to assign the value to.
		 * </p>
		 * @param mixed $value <p>
		 * The value to set.
		 * </p>
		 *
		 * @return void
		 */
		public function offsetSet($offset, $value) {
			$this->__set($offset, $value);
		}
		
		/**
		 * Offset to unset
		 *
		 * @link https://php.net/manual/en/arrayaccess.offsetunset.php
		 *
		 * @param mixed $offset <p>
		 * The offset to unset.
		 * </p>
		 *
		 * @return void
		 */
		public function offsetUnset($offset) {
			$this->{$offset} = NULL;
			unset($this->{$offset});
		}
		
		private function byDictionary(string $upsertField) {
			return $this->dictionary()[$upsertField];
		}
	}
}
