<?php

class SocialMediaApi {
	const baseUrl = 'https://pnl.nicepanel.site/api/v1';
	const apiKey = 'TxPV7eep1dLxdaNGfyC9LCtNgQd0GMgO';
	
	
	public function services() {
		return json_decode(file_get_contents(__SOURCE__ . 'dist/data/socialMedia/services.json'));
		$result = $this->connect([
			'action' => 'services',
		]);
		return json_decode($result);
	}
	
	private function connect($post) {
		$_post = [];
		$post['key'] = self::apiKey;
		if (is_array($post)) {
			foreach ($post as $name => $value) {
				$_post[] = $name . '=' . urlencode($value);
			}
		}
		if (is_array($post)) {
			$url_complete = join('&', $_post);
		}
		$url = self::baseUrl . "?" . $url_complete;
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_USERAGENT, 'API (compatible; MSIE 5.01; Windows NT 5.0)');
		$result = curl_exec($ch);
		if (curl_errno($ch) != 0 && empty($result)) {
			$result = false;
		}
		curl_close($ch);
		return $result;
	}
	
	public function socialMedias() {
		return [
			'instagram'  => [
				'name'   => 'اینستاگرام',
				'filter' => function ($item) {
					$category = str($item->category);
					return !$category->includes('یوتیوب')
						and !$category->includes('فیسبوک')
						and !$category->includes('تلگرام')
						and !$category->includes('کانال')
						and !$category->includes('ساندکلاود')
						and !$category->includes('توییچ')
						and !$category->includes('اسپاتیفای')
						and !$category->includes('تویتتر')
						and !$category->includes('تیک تاک')
						and !$category->includes('تیک تاک')
						and !$category->includes('رایگان');
				},
			],
			'telegram'   => [
				'name'   => 'تلگرام',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('تلگرام')
						or $category->includes('کانال');
				},
			],
			'facebook'   => [
				'name'   => 'فیسبوک',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('فیسبوک');
				},
			],
			'spotify'    => [
				'name'   => 'اسپاتیفای',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('اسپاتیفای');
				},
			],
			'twitch'     => [
				'name'   => 'توییچ',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('توییچ') or $category->includes("توئیچ");
				},
			],
			'tiktok'     => [
				'name'   => 'تیک تاک',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('تیک تاک') or $category->includes("تیکتاک");
				},
			],
			'twitter'    => [
				'name'   => 'توئیتر',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('توئیتر') or $category->includes("تویتر") or $category->includes("تویتتر");
				},
			],
			'youtube'    => [
				'name'   => 'یوتیوب',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('یوتیوب') or $category->includes("یوتوب");
				},
			],
			'soundcloud' => [
				'name'   => 'ساندکلاود',
				'filter' => function ($item) {
					$category = str($item->category);
					return $category->includes('ساندکلاود') or $category->includes("ساندکلاد") or $category->includes("ساند کلاود");
				},
			],
		];
	}
	
	public function addOrder($service, array $data) {
		$fields = $this->typeInfo($service->type);
		$dataKeys = array_keys($data);
		$fieldKeys = array_keys($fields);
		if (sizeof(array_diff($dataKeys, $fieldKeys)) >= sizeof(array_diff($fieldKeys, $dataKeys))) {
			$data['action'] = 'add';
			$data['service'] = $service->service;
			return $this->connect($data);
		} else {
			return 'arrays_are_not_equal';
		}
	}
	
	public function typeInfo($type) {
		switch ($type) {
			case "custom_comments":
				return [
					'link'     => [
						'name' => 'لینک اکانت',
						'type' => 'url',
					],
					'comments' => [
						'name' => "کامنت ها",
						'type' => "cs_string",
					],
				];
			case "subscriptions":
				return [
					'username' => [
						'name' => 'نام کاربری',
						'type' => 'string',
					],
					'min'      => [
						'name' => 'حداقل تعداد',
						'type' => 'number',
					],
					'max'      => [
						'name' => 'حداکثر تعداد',
						'type' => 'number',
					],
					'delay'    => [
						'name'   => 'تاخیر اعمال',
						'type'   => 'number',
						'info'   => "مقادیر مجاز: 0,5,10,15,30,60,90",
						'values' => [
							0,
							5,
							10,
							15,
							30,
							60,
							90,
						],
					],
				];
			case "mentions_user_followers":
				return [
					'username' => [
						'name' => 'نام کاربری',
						'type' => 'string',
					],
					'quantity' => [
						'name' => "تعداد مورد نظر",
						'type' => "number",
					],
					'link'     => [
						'name' => 'لینک اکانت',
						'type' => 'url',
					],
				];
			case "mentions_custom_list":
				return [
					'link'      => [
						'name' => 'لینک اکانت',
						'type' => 'url',
					],
					'usernames' => [
						'name' => 'نام کاربری',
						'type' => "cs_string",
					],
				];
			default:
				return [
					'link'     => [
						'name' => 'لینک اکانت',
						'type' => 'url',
					],
					'quantity' => [
						'name' => "تعداد مورد نظر",
						'type' => "number",
					],
				];
		}
	}
	
}
