<?php

namespace helpers;

use FwHtml\Elements\Tags\Main\HtmlTags;

final class PaymentStatus {

    static protected $arrayOfDays = ['2' => 'تحویل داده شد', '1' => 'ارسال شد', '0' => 'در حال انجام', '3' => 'لغو شد',];

    public static function toOption(bool $selected = true) {
        $output = [];
        foreach (self::toArray() as $key => $item) {
            $output[] = HtmlTags::Option()->Value($key)->Content($item);
        }
        return implode('', $output);
    }

    public static function toArray() {
        return self::$arrayOfDays;
    }

    public static function toHtml($data) {
        $allCount = en_to_fa(number_format(count($data)));
        $output = [HtmlTags::Div("همه: $allCount")->Class("form-group m-1 p-3 bg-dark rounded")];
        foreach (self::toArray() as $index => $item) {
            switch ($index) {
                case 0:
                    $bg = "warning";
                    break;
                case 1:
                    $bg = "primary";
                    break;
                case 2:
                    $bg = "success";
                    break;
                case 3:
                    $bg = "danger";
                    break;
                default:
                    $bg = "dark";
                    break;
            }
            $count = (count(array_filter($data,function ($item) use ($index) {
                return $item->order_status == $index;
            })));
            $count = en_to_fa(number_format($count));
            $item = "$count سفارش $item";
            $output[] = HtmlTags::Div($item)->Class("form-group m-1 p-3 bg-$bg rounded");
        }
        return implode('',$output);
    }

    public static function ItemToHtml($order_status) {
        switch ($order_status) {
            case 0:
                $bg = "warning";
                break;
            case 1:
                $bg = "primary";
                break;
            case 2:
                $bg = "success";
                break;
            case 3:
                $bg = "danger";
                break;
            default:
                $bg = "dark";
                break;
        }
        $name = self::$arrayOfDays[$order_status];
        return "<div class='bg-$bg rounded p-1'>$name</div>";
    }

	public static function toString($pay_status) {
		return self::$arrayOfDays[$pay_status];
	}
}
