<?php

use model\ChargeOperators;
use model\Entity\ChargeOperatorsEntity;

class MobinOneCharges {
	const baseUrl = 'https://cp.mobinone.org:33552';
	
	public static function buyCharge($operator, $amount, $mobile, $resNum) {
		$operator = ChargeOperators::get($operator);
		$mobile = self::toMobileFormat($mobile);
		$body = [
			"identifier" => "mSRspft",
			"operator"   => $operator instanceof ChargeOperatorsEntity ? $operator->short : 'mtn',
			"type"       => "normal",
			"amount"     => "$amount",
			"merchant"   => "نگارینه",
			"number"     => ["$mobile"],
			"requestId"  => ["$resNum"],
		];
		return CallAPI('post', self::baseUrl . '/directCharge', $body, ['Authorization' => "Bearer " . FwConfig::MobineOneToken()], true);
	}
	
	private static function toMobileFormat($mobile) {
		return str($mobile)->split()->removeFirst()->join('');
	}
	
	public static function buyPackage($operator, $packageCode, $packageCost, $mobile, $resNum) {
		$operator = ChargeOperators::get($operator);
		$mobile = self::toMobileFormat($mobile);
		$body = [
			"identifier"  => "mSRspft",
			"operator"    => $operator instanceof ChargeOperatorsEntity ? $operator->short : 'mtn',
			"packageCode" => "$packageCode",
			"packageCost" => "$packageCost",
			"merchant"    => "نگارینه",
			"number"      => ["$mobile"],
			"requestId"   => ["$resNum"],
		];
		return CallAPI('post', self::baseUrl . '/buyPackage', $body, ['Authorization' => "Bearer " . FwConfig::MobineOneToken()], true);
	}
	
	public static function getPackages($operator, $type) {
		$operator = ChargeOperators::get($operator);
		$body = [
			"identifier" => "mSRspft",
			"operator"   => $operator instanceof ChargeOperatorsEntity ? $operator->short : 'mtn',
			"userType"   => $type,
		];
		return CallAPI('post', self::baseUrl . '/getPackages', $body, ['Authorization' => "Bearer " . FwConfig::MobineOneToken()], true);
	}
}
