<?php

namespace helpers;

use FwHtml\Elements\Tags\Main\HtmlTags;

final class DayHelper {
	
	static protected $arrayOfDays = [
		'Saturday'  => 'شنبه',
		'Sunday'    => 'یک شنبه',
		'Monday'    => 'دو شنبه',
		'Tuesday'   => 'سه شنبه',
		'Wednesday' => 'چهار شنبه',
		'Thursday'  => 'پنج شنبه',
		'Friday'    => 'جمعه',
	];
	
	public static function toOption(bool $selected = true) {
		$output = [];
		foreach (self::toArray() as $key => $item) {
			$output[] = HtmlTags::Option()->Value($key)->Content($item);
			if ($selected) end($output)->Selected();
		}
		return implode('', $output);
	}
	
	public static function toArray() {
		return self::$arrayOfDays;
	}
	
	public static function isShiftOkForTommorow($shift) {
		return in_array(self::dayAfter(), json_decode($shift->sending_time_days, true));
	}
	
	public static function dayAfter($day = NULL) {
		if ($day == NULL) {
			$day = date('l');
		}
		return date('l', strtotime("tomorrow", strtotime($day)));
	}
	
	public static function shiftsForToday($shifts) {
		$output = [];
		foreach ($shifts as $shift) {
			if (in_array(self::today(), json_decode($shift->sending_time_days, true))) {
				$output[] = $shift;
			}
		}
		return $output;
	}
	
	public static function today() {
		return date('l');
	}
	
	public static function shiftsForTommorow($shifts) {
		$output = [];
		foreach ($shifts as $shift) {
			if (in_array(self::today(), json_decode($shift->sending_time_days, true))) {
				$output[] = $shift;
			}
		}
		return $output;
	}
	
	public static function firstDayForShift($currentShift) {
		return 48;
	}
	
	public static function isShiftLeft(array $shiftForToday) {
		
		$hour = date("H");
		$minute = date("i");
		$output = [];
		foreach ($shiftForToday as $shift) {
			
			$startArray = explode(':', $shift->sending_time_start);
			$startHour = $startArray[0];
			$startMinute = $startArray[1];
			$endArray = explode(':', $shift->sending_time_end);
			$endHour = $endArray[0];
			$endMinute = $endArray[1];
			$penaltyHour = $shift->sending_time_penalty / 60;
			if ($penaltyHour >= 1) {
				$test = $hour < $startHour - $penaltyHour;
			} else {
				$test = ($hour <= $startHour) and $minute < ($startMinute + $penaltyHour * 60);
			}
			if ($test) return true;
		}
		return false;
	}
	
	public static function getShiftsLeft(array $shiftForToday) {
		
		$hour = date("H");
		$minute = date("i");
		$output = [];
		foreach ($shiftForToday as $shift) {
			
			$startArray = explode(':', $shift->sending_time_start);
			$startHour = $startArray[0];
			$startMinute = $startArray[1];
			$endArray = explode(':', $shift->sending_time_end);
			$endHour = $endArray[0];
			$endMinute = $endArray[1];
			$penaltyHour = $shift->sending_time_penalty / 60;
			if ($penaltyHour >= 1) {
				$test = $hour < $startHour - $penaltyHour;
			} else {
				$test = ($hour <= $startHour) and $minute < ($startMinute + $penaltyHour * 60);
			}
			if ($test) {
				$output[] = $shift;
			}
		}
		return $output;
	}
	
	public static function UniqueShifts(array $shiftsForToday) {
		$output = [];
		/** @var $item */
		foreach ($shiftsForToday as $item) {
			$output[] = $item;
		}
		return $output;
	}
	
	public static function isShiftOkForToday($row) {
		return in_array(self::today(), json_decode($row->sending_time_days, true));
		
	}
}
