<?php

namespace Api;

use FwRoutingSystem\Router;
use middlewares\RouterMiddleware;

abstract class BaseRouter {
	public $groupPath;
	
	abstract public function routes(Router $router);
	
	abstract public function requiredHeaders() : array;
	
	final public function getParam(string $key, bool $isRequired = true, callable $validator = NULL, array $errorMessage = NULL) {
		if ($isRequired) {
			if (isset($_POST[$key])) {
				if (is_callable($validator)) {
					if (!$validator($_POST[$key])) {
						if (!$errorMessage) $errorMessage = ['message' => "$key is not valid"];
						echo response($errorMessage, 400);
						die();
					}
				}
			} else {
				$errorMessage = ['message' => "$key is required"];
				echo response($errorMessage, 400);
				die();
			}
		} else {
			if (isset($_POST[$key])) {
				if (is_callable($validator)) {
					if (!$validator($_POST[$key])) {
						if (!$errorMessage) $errorMessage = ['message' => "$key is not valid"];
						echo response($errorMessage, 400);
						die();
					}
				}
			}
		}
		return trim($_POST[$key]);
	}
	
	final protected function middleware(Router $router) {
		return [
			'before' => new RouterMiddleware($this, $router),
		];
	}
}
