<?php

namespace CodeGenerator\Classes;
class ClassEditor {
	static public function addTrait(string $filePath, string $trait) {
		$traitName = explode('\\',$trait);
		$traitName = end($traitName);
		$text = file_get_contents($filePath);
		$text = self::str_insert_after($text, ' {', "\n\tuse $traitName;");
		$text = self::str_insert_before($text,'class',"use $trait;\n\n");
		if (file_put_contents($filePath, $text)) {
			return true;
		}
		return false;
	}
	
	static function str_insert_after($str, $search, $insert) {
		$index = strpos($str, $search);
		if ($index === false) {
			return $str;
		}
		return substr_replace($str, $search . $insert, $index, strlen($search));
	}
	
	static function str_insert_before($str, $search, $insert) {
		$index = strpos($str, $search);
		if ($index === false) {
			return $str;
		}
		return substr_replace($str, $insert, $index, 0);
	}
}
