<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use model\Entity\IndividualsEntity;
use model\Entity\VisitorsEntity;

class Visitors extends ControllerScheme
{

    use ApiInterface;

    const name = 'مشتری';
    public static $__uploads = ["visitor_image" => __SOURCE__ . "images/Visitors/Visitors/"];


    public function add(?bool $csrf = true)
    {
        $data = $this->requestArray();
        $info = [
            'individual_id' => $data['individual_id'],
            'level_id' => $data['level_id'],
            'visitor_national_code' => $data['visitor_national_code'],
            'visitor_birthday' => time($data['visitor_birthday']),
            'visitor_father_name' => $data['visitor_father_name'],
            'visitor_tell' => $data['visitor_tell'],
            'visitor_postal_code' => $data['visitor_postal_code'],
            'visitor_birthplace' => $data['visitor_birthplace'],
            'visitor_marital_status' => $data['visitor_marital_status'],
            'visitor_number_children' => $data['visitor_number_children'],
            'visitor_email' => $data['visitor_email'],
            'visitor_username' => $data['visitor_username'],
            'visitor_password' => $data['visitor_password'],
            'visitor_image' => $data['visitor_image'],
            'visitor_score' => $data['visitor_score'],
            'visitor_credit' => $data['visitor_credit'],
            'visitor_introduction' => $data['visitor_introduction'],
            'visitor_introduction_from' => $data['visitor_introduction_from'],
            'visitor_description' => $data['visitor_description'],
        ];
        $res = $this->model()::add($info);
        return showResult(true, ' کد معرفی شما = ' . '( ' . $data['visitor_introduction'] . ' ) ' . 'ثبت اطلاعات ', '');
    }

    public function register()
    {
        $output = [
            'status' => false,
            'error' => [
                'doesNationalCodeExist' => false,
                'doesMobileExist' => false,
                'isIntroductionNotFound' => false,
            ],
        ];
        $name = $this->ApiParam('name');//نام
        $lastName = $this->ApiParam('lastName'); //نام خانوادگی
        $mobile = $this->ApiParam('mobile');//موبایل
        $nationalCode = $this->ApiParam('nationalCode');//کد ملی
        $introductionFrom = $this->ApiParam('introductionFrom');//کد معرف
        $unique = UniqueOfClass(new \model\Visitors(), 'visitor_introduction', false, 6, false, false);//کد معرف شخص
        $nationalCodeCount = \model\Visitors::Db()->where("visitor_national_code", $nationalCode)->rowCount();
        $individual_ids = \model\Visitors::getAll()->map(function ($visitor) {
            return $visitor->individual_id;
        })->all();
        $mobileCount = \model\Individuals::Db()->whereIn('individual_id', $individual_ids)->get()->filter(function ($item) use ($mobile) {
            return $item->mobile == $mobile;
        })->length();
        $introduction = \model\Visitors::Db()->where("visitor_introduction", $introductionFrom)->rowCount();

        if ($nationalCodeCount > 0) $output['error']['doesNationalCodeExist'] = true;

        if ($mobileCount > 0) $output['error']['doesMobileExist'] = true;

        if ($introduction == 0) $output['error']['isIntroductionNotFound'] = true;

        if (!($nationalCodeCount > 0) and !($mobileCount > 0) and !($introduction == 0)) {
            $newId = \model\Individuals::add([
                'individual_first_name' => $name,
                'individual_last_name' => $lastName,
                'individual_mobile' => $mobile,
            ]);
            if ($newId > 0) {
                $visitorId = \model\Visitors::add([
                    'visitor_national_code' => $nationalCode,
                    'visitor_introduction_from' => $introductionFrom,
                    'individual_id' => $newId,
                    'visitor_introduction' => $unique
                ]);
                if ($visitorId > 0) {
                    $output['status'] = true;
                    $output['visitorId'] = $visitorId;
                } else {
                    $output['error']['message'] = 'error_in_visitor_add';
                }
            } else {
                $output['error']['message'] = 'error_in_individual_add';
            }
        }
        return $output;
    }

    public function completeRegister()
    {
        $output = [
            'status' => false,
            'error' => [
                'doesVisitorExist' => true,
                'errorOnSave' => false,
            ],
        ];
        $requestUsername = $this->ApiParam('username');
        $requestPassword = $this->ApiParam('password');
        $visitorId = $this->ApiParam('id');

        $visitor = \model\Visitors::get($visitorId);
        $res_username = \model\Visitors::Db()->where("visitor_username", $requestUsername)->rowCount();
        var_dump($res_username);
        if($res_username > 0 ) {
            $output['status']['doesUsernameExist'] = true;
        }
        if($res_username == 0 ){
            if ($visitor instanceof VisitorsEntity) {
                $visitor->username = str_replace(' ',    '', $requestUsername);
                $visitor->password = sha1(md5(trim(str_replace(' ', '', $requestPassword))));
                if ($visitor->save()){
                    $output['status'] = true;
                } else {
                    $output['error']['errorOnSave'] = true;
                }
            } else {
                $output['status']['doesVisitorExist'] = true;
            }
        }


        return $output;

    }

    public function Login()
    {
        $output = [
            'status' => false,
            'error' => [
                'doesUsernameExist' => false,
                'isPasswordWrong' => false,
            ],
        ];
        $username = $this->ApiParam('username');
        $password = $this->ApiParam('password');
        $visitor = \model\Visitors::getByUserName($username);
        if ($visitor instanceof VisitorsEntity) {
            if ($visitor->password == sha1(md5($password))) {
                $output['status'] = true;
            } else {
                $output['error']['isPasswordTrue'] = true;
            }
        } else {
            $output['error']['doesUsernameExist'] = true;
        }
        return $output;
    }

    public function forgotPassword()
    {
        $output = [
            'status' => false,
            'error' => [
                'visitorNotFound' => false,
                'saveHasError' => false,
            ]
        ];

        $username = $this->ApiParam('username');
        $visitor = \model\Visitors::getByUserName($username);
        if ($visitor instanceof VisitorsEntity) {
            /** @var IndividualsEntity $individual */
            $individual = \model\Individuals::get($visitor->individual_id);
            $mobile = $individual->mobile;
            $code = generateRandomString(6, true);
            sendVerify($mobile, [$code]);
            $visitor->code = $code;
            if ($visitor->save()) {
                $output['status'] = true;
                unset($output['error']);
            } else {
                $output['error']['saveHasError'] = true;
            }
        }


        else {
            $output['error']['visitorNotFound'] = true;
        }
        return $output;
    }

    public function comfermPassword(){}

}
