<?php

namespace controller;

use ControllerScheme;
use FwAuthSystem\Main\UserObject;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

class VoucherCodes extends ControllerScheme {
	const name = 'کد تخفیف';
	
	
	public function upload() {
		return $this->view($this->viewName(), 'upload', [
		]);
	}
	
	public function uploadExcel() {
		$xls = file_get_contents($_FILES['voucher_codes_excel']['tmp_name']);
		$xls = str_replace("\n", '', $xls);
		$xls = str_replace("\r", '', $xls);
		$xls = str_replace("\t", '', $xls);
		$xls = str_replace(" ", '', $xls);
		$xls = str_replace(chr(10), '', $xls);
		$xls = str_replace(chr(13), '', $xls);
		$xls = str_replace("
		", '', $xls);
		$xls = str_split($xls, 8);
		$voucher_code_provider_id = $this->requestArray()['voucher_code_provider_id'];;
		$voucher_code_user_count = $this->requestArray()['voucher_code_user_count'];
		$voucher_code_percent = $this->requestArray()['voucher_code_percent'];
		$voucher_code_description = $this->requestArray()['voucher_code_description'];
		$codes = $xls;
		$i = 0;
		$db = Db::table('tblActiveList');
		$time = time();
		$uniqueCodes = array_unique($codes);
		foreach ($uniqueCodes as $unique_code) {
			$voucher_code_count = array_count_values_of($unique_code, $codes);
			if ($voucher_code_count < $voucher_code_user_count) {
				$voucher_code_user_count = $voucher_code_count;
			}
			$id = $this->model()::add([
				'voucher_code'             => $unique_code,
				'voucher_code_provider_id' => $voucher_code_provider_id,
				'voucher_code_count'       => $voucher_code_count,
				'voucher_code_user_count'  => $voucher_code_user_count,
				'voucher_code_percent'     => $voucher_code_percent,
				'voucher_code_description' => $voucher_code_description,
				'voucher_code_submit_date' => $time,
			]);
			if (!($id > 0)) {
				return showResult(false, "کد تخفیف {$unique_code}", "بارگذاری");
			} else {
				$i++;
				$db->insert([
					'item_id'    => $id,
					'table_name' => 'tblVoucherCodes',
					'date'       => time(),
					'user_id'    => UserObject::instance()->getUserId(),
				]);
			}
		}
		return showResult(true, "{$i} کد تخفیف", "بارگذاری");
	}
	
	public function addgroups() {
		return $this->addIndex();
	}
	
	public function editgroups() {
		return $this->editIndex();
	}
	
	public function groups() {
		return $this->main();
	}
	
	public function main() {
		if (isset($_REQUEST['codeGroup'])) {
			return $this->view($this->viewName(), 'main', [
				$this->model()::getAllFiltered("voucher_code_submit_date", $_REQUEST['codeGroup'])->reject(function ($item) {
					return !isActive($this, $item);
				}),
			]);
		} else {
			
			return $this->view($this->viewName(), 'groups', [
				\model\VoucherCodes::selectDistinctDates(),
			]);
		}
	}
}
