<?php

namespace controller;

use model\Startups;
use ControllerScheme;
use Api\ApiInterface;
use model\VoucherCodes;
use model\VoucherCodeProviders;
use model\Entity\StartupsEntity;
use model\Entity\VoucherCodesEntity;
use model\Entity\VoucherCodeServicesEntity;
use model\Entity\VoucherCodeProvidersEntity;

class VoucherCodeServices extends ControllerScheme {
	use ApiInterface;
	
	const name = 'سرویس تخفیف';
	
	public function upload() {
		return $this->view($this->viewName(), 'upload', [
		]);
	}
	
	public function uploadExcel() {
		$voucher_code_ids = $this->requestArray('voucher_code_ids');
		$i = 0;
		foreach ($voucher_code_ids as $voucher_code_id) {
			/** @var VoucherCodesEntity $voucher_code */
			$voucher_code = VoucherCodes::getOneFiltered("voucher_code", $voucher_code_id);
			if (
			\model\VoucherCodeServices::add([
					'startup_id'                       => $this->requestArray('startup_id'),
					'voucher_code_id'                  => $voucher_code->voucher_code_id,
					'voucher_code_service_count'       => $this->requestArray('voucher_code_service_count'),
					'voucher_code_service_user_count'  => $this->requestArray('voucher_code_service_user_count'),
					'voucher_code_service_expire_date' => $this->requestArray('voucher_code_service_expire_date'),
				]
			)
			) {
				$i++;
			}
		}
		return showResult(true, "{$i} کد تخفیف", "بارگذاری");
		
	}
	
	public function GetVoucherCode() {
		$startupToken = $this->ApiParam('startupToken');
		$providerCode = $this->ApiParam('providerCode');
		$userId = $this->ApiParam('userId');
		$providerId = explode('_', $providerCode)[0];
		$percent = explode('_', $providerCode)[1];
		/** @var VoucherCodeServicesEntity $voucherCodeService */
		/** @var VoucherCodesEntity $code */
		/** @var VoucherCodeProvidersEntity $provider */
		$startup = Startups::getByToken($startupToken);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof VoucherCodeServicesEntity) {
				$code = VoucherCodes::Db()->where([
					'voucher_code_provider_id' => "$providerId",
					'voucher_code_percent'     => "$percent",
				])->orderBy('', true)->limit(1)->get()->first();
				if ($code instanceof VoucherCodesEntity) {
					$codeString = $code->code;
					$usedCount = \model\VoucherUseCodes::Db()->where(
						[
							'voucher_code_user_id' => $userId,
							'code_id_generated'    => $providerCode,
						]
					)->rowCount();
					if ($code->code_user_count == 1 && $usedCount > 0) {
						return [
							'status'  => false,
							'message' => 'userUsedBefore',
						];
					}
					if ($code->code_count <= \model\VoucherUseCodes::getAllFiltered("voucher_code", $code->code)->length()) {
						$code->delete();
					}
					\model\VoucherUseCodes::add([
						'voucher_code'           => $codeString,
						'voucher_code_user_id'   => $userId,
						'code_id_generated'      => $providerCode,
						'voucher_code_user_date' => time(),
					]);
					return [
						'status'      => true,
						'voucherCode' => $code->code,
					];
				}
				return [
					'status'  => false,
					'message' => 'codeNotFound',
				];
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToVoucherCodeService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
	}
	
	public function VoucherCodeList() {
		$startupToken = $this->ApiParam('startupToken');
		$userId = $this->ApiParam('userId');
		/** @var VoucherCodeServicesEntity $voucherCodeService */
		/** @var VoucherCodesEntity $code */
		/** @var VoucherCodeProvidersEntity $provider */
		$output = [];
		$startup = Startups::getByToken($startupToken);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof VoucherCodeServicesEntity) {
				foreach (\model\VoucherCodeServices::getAll() as $voucherCodeService) {
					$code = VoucherCodes::get($voucherCodeService->code_id);
					$providerId = $code->code_provider_id;
					$provider = VoucherCodeProviders::get($providerId);
					$uniqueCode = "$providerId" . "_$code->percent";
					$data = $provider->apiFormat();
					$data['percent'] = $code->percent;
					$data['expireDate'] = date("Y/m/d H:i:s", $voucherCodeService->code_service_expire_date);
					$data['description'] = $code->description;
					$data['code'] = $uniqueCode;
					if (\model\VoucherUseCodes::Db()->where([
							'code_id_generated'    => $uniqueCode,
							'voucher_code_user_id' => $userId,
						])->rowCount() == 0) {
						$output[$uniqueCode] = $data;
					}
				}
				return [
					'status'       => true,
					'voucherCodes' => array_values($output),
				];
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToVoucherCodeService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
	}
}
