<?php
namespace controller;
use ControllerScheme;
use FwConnection;
use FwHtml\Elements\Tags\Main\HtmlTags;

class CreditConversion extends ControllerScheme
{
    const name = 'تبدیل امتیاز';



    public function add(?bool $csrf = true)
    {
        $request = $this->requestArray();

        if ($request['credit_after'] == 0 || $request['credit_after'] == "0") $creditAfter = intval($request['credit_before']);
        else $creditAfter = intval($request['credit_after']);
        if ($request['score_after'] == 0 || $request['score_after'] == "0") $scoreAfter = intval($request['score_before']);
        else $scoreAfter = intval($request['score_after']);


        $transaction = [
            'customer_id' => intval($request['customer_id']),
            'startup_id' => intval($request['startup_id']),
            'score_before' => intval($request['score_before']),
            'score_after' => $scoreAfter,
            'credit_before' => intval($request['credit_before']),
            'credit_after' => $creditAfter,
            'score_to_club_score' => intval($request['score_to_club_score']),
            'club_score_from_score' => intval($request['club_score_from_score']),
            'score_to_club_credit' => intval($request['score_to_club_credit']),
            'club_credit_from_score' => intval($request['club_credit_from_score']),
            'credit_to_club_score' => intval($request['credit_to_club_score']),
            'club_score_from_credit' => intval($request['club_score_from_credit']),
            'user_id' => intval($request['user_id']),
            'validations' => $request['validations']
        ];

        \model\Customers::edit(intval($request['customer_id']),[
            'customer_score' => $scoreAfter,
            'customer_credit' => $creditAfter
        ]);

        $this->setRequestArray($transaction);
        return parent::add($csrf); // TODO: Change the autogenerated stub
    }

    public function main() {

        $res =  $this->model()::Db()->where('score_to_club_score IS NOT NULL');


//        $this->view($this->viewName(),'main',[
//               return $this->view($this->viewName(),'main',[
//           $this->model()::Db()->where('score_to_club_score !== NULL')
//            ]);

        return $this->view($this->viewName(),'main',[
                $res->get()
            ]);

//        return parent::main();
    }

}