<?php

namespace controller;

use ControllerScheme;
use FwConnection;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;

class ChargeCredit extends ControllerScheme
{
    const name = 'تراکنش';

    public function add(?bool $csrf = true)
    {
        $request = $this->requestArray();

        if ($request['credit_after'] == 0 || $request['credit_after'] == "0") $creditAfter = intval($request['credit_before']);
        else $creditAfter = intval($request['credit_after']);
        if ($request['score_after'] == 0 || $request['score_after'] == "0") $scoreAfter = intval($request['score_before']);
        else $scoreAfter = intval($request['score_after']);

        $transaction = [
            'customer_id' => intval($request['customer_id']),
            'score_before' => intval($request['score_before']),
            'score_after' => $scoreAfter,
            'credit_before' => intval($request['credit_before']),
            'credit_after' => $creditAfter,
            'validations' => $request['validations'],
            'user_id' => intval($request['user_id'])
        ];

        \model\Customers::edit(intval($request['customer_id']), [
            'customer_score' => $scoreAfter,
            'customer_credit' => $creditAfter
        ]);

        $this->setRequestArray($transaction);
        return parent::add($csrf); // TODO: Change the autogenerated stub
    }

    public function main() {

        $res =  $this->model()::Db()->where('score_to_club_score IS NULL');
        return $this->view($this->viewName(),'main',[
            $res->get()
        ]);

    }

}