<?php

namespace controller;

use ControllerScheme;
use model\Entity\LevelsEntity;
use model\Entity\StartupsEntity;
use model\Entity\SocialMediaServicesEntity;

class SocialMediaServices extends ControllerScheme {
	const name = 'سرویس شبکه مجازی';
	
	
	public function main() {
		$SocialMedia = new \SocialMediaApi();
		return $this->view($this->viewName(), 'main', [
			$SocialMedia->services(),
		]);
	}
	
	public function savePrice() {
		$serviceId = $this->requestArray('serviceId');
		$percent = $this->requestArray('percent');
		$service = \model\SocialMediaServices::getOneFiltered('service_id', $serviceId);
		if ($service instanceof SocialMediaServicesEntity) {
			if (\model\SocialMediaServices::edit($service->social_media_service_id, [
				'social_media_service_percent' => $percent,
			])) {
				return 1;
			}
		} else {
			if (\model\SocialMediaServices::add([
				'service_id'                   => $serviceId,
				'social_media_service_percent' => $percent,
			])) {
				return 1;
			}
		}
		return 0;
	}
	
	public function saveLevelDiscount() {
		$serviceId = $this->requestArray('serviceId');
		$levelId = $this->requestArray('levelId');
		$percent = $this->requestArray('percent');
		/** @var LevelsEntity $level */
		$level = \model\Levels::get($levelId);
		$service = \model\SocialMediaServices::getOneFiltered('service_id', $serviceId);
		if ($service instanceof SocialMediaServicesEntity) {
			$json = json_decode($service->levels, true);
			if ($json) {
				if (isset($json[$level->startup_id . ''])) {
					$json[$level->startup_id . ''][$levelId . ''] = $percent;
				} else {
					$json[$level->startup_id . ''] = [];
					$json[$level->startup_id . ''][$levelId . ''] = $percent;
				}
			} else {
				$json = [];
				$json[$level->startup_id . ''] = [];
				$json[$level->startup_id . ''][$levelId . ''] = $percent;
			}
			if (\model\SocialMediaServices::edit($service->social_media_service_id, [
				'social_media_service_levels' => json_encode($json),
			])) {
				return 1;
			}
		} else {
			$json = [
				$level->startup_id . '' => [
					$levelId . '' => $percent,
				],
			];
			if (\model\SocialMediaServices::add([
				'service_id'                => $serviceId,
				'social_media_service_levels' => json_encode($json),
			])) {
				return 1;
			}
		}
		return 0;
	}
	
	public function levelDiscounts() {
		$SocialMedia = new \SocialMediaApi();
		return $this->view($this->viewName(), 'levelDiscounts', [
			[
				\model\Startups::getAllActives()->map(function (StartupsEntity $startup) {
					$startup->levels = \model\Levels::getAllFiltered('startup_id', $startup->id);
					return $startup;
				})->all(),
				$SocialMedia->services(),
			],
		]);
	}
}
