<?php

namespace controller;

use ControllerScheme;
use Api\ApiInterface;
use model\Entity\StartupsEntity;
use model\Entity\CarServicesEntity;

class CarServices extends ControllerScheme {
	use ApiInterface;
	
	const name = 'سرویس خودرو';
	
	
	public function UserCars() {
		$startup = get_header('startupToken');
		$page = $this->ApiParam('page');
		$startup = \model\Startups::getByToken("$startup");
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof CarServicesEntity) {
				$result = json_decode(CallAPI('post', $this->generatePath('CustomerCars', 'customerCars') . "&page=$page", [
					'mobile' => $this->ApiParam('mobile'),
				]));
				if ($result->isDone) {
					return [
						'status' => true,
						'cars'   => $result->data,
					];
				} else {
					
					return [
						'status'  => false,
						'message' => 'provider_error',
						'info'    => [
							'serviceProvider' => 'samannegar',
							'error'           => $result->data,
						],
					];
				}
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToCarService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
	}
	
	private function generatePath(string $controller, string $method) {
		return "https://new.samannegar.negarine.com/CarInterface/{$controller}/API/_$method?token=test";
	}
	
	public function allCarGroups() {
		$startup = get_header('startupToken');
		$page = $this->ApiParam('page');
		$startup = \model\Startups::getByToken($startup);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof CarServicesEntity) {
				$result = json_decode(CallAPI('get', $this->generatePath('CarGroups', 'allGroups') . "&page=$page"));
				if ($result->isDone) {
					return [
						'status' => true,
						'groups' => $result->data,
					];
				} else {
					
					return [
						'status'  => false,
						'message' => 'provider_error',
						'info'    => [
							'serviceProvider' => 'samannegar',
							'error'           => $result->data,
						],
					];
				}
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToCarService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
	}
	
	public function allCarBrands() {
		$startup = get_header('startupToken');
		$page = $this->ApiParam('page');
		$startup = \model\Startups::getByToken($startup);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof CarServicesEntity) {
				$result = json_decode(CallAPI('get', $this->generatePath('CarBrands', 'allBrands') . "&page=$page"));
				if ($result->isDone) {
					return [
						'status' => true,
						'brands' => $result->data,
					];
				} else {
					return [
						'status'  => false,
						'message' => 'provider_error',
						'info'    => [
							'serviceProvider' => 'samannegar',
							'error'           => $result->data,
						],
					];
				}
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToCarService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
	}
}
